/**
 * Fecha de creacin: (17/11/2010)
 */   
package com.ejie.p06b.pdf.xml;

import javax.servlet.http.HttpServletRequest;
import com.ejie.p06b.datatype.logic.P06BInformeOtroDEC;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.util.P06BUtil;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;

/**
 * Clase que representa el xml para el pdf
 */
public class P06BInformeOtroResumenDECXML{
   
	public static String getXml(HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BInformeOtroResumenDECXML", "getXml(...): Inicio");
		
    	P06BResources res = (P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS);
		
		//Obtener el idioma
		//String idioma = null;
		P06BPerfilUsuario perfilUsuario = (P06BPerfilUsuario) request.getSession().getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);
		//if (perfilUsuario != null){
		//	idioma = perfilUsuario.getIdIdioma();
		//}
		//if (idioma == null || idioma.equals("") ){
		//	idioma = P06BConstantes.P06B_IDIOMA_ES; //"es"
		//}

		String fechaActualStr = P06BFecha.getFechaFormateada(new Date(), perfilUsuario.getLocale());
		
		DecimalFormat decimalFormat = new DecimalFormat("####.####");
		
		String ejerDEC = (request.getParameter("EjercicioResumenDEC")==null)?"":request.getParameter("EjercicioResumenDEC");
		
		//Hacer las SELECT a la base de datos, para calcular los campos, y cargar el objeto P06BInformeDEC con los datos calculados
		P06BInformeOtroDEC objInformeOtroDEC = P06BCorredoresManager.getInstance().selectInformeOtroResumenDEC(ejerDEC);

		StringBuffer xml = new StringBuffer();
	
		xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		xml.append("<informeDEC>");
		
			xml.append("<cav>");
			xml.append(res.get("listados.otroResumen.cav"));
			xml.append("</cav>");
			xml.append("<titulo>");
			xml.append(res.get("listados.otroResumen.titulo"));
			xml.append("</titulo>");
			xml.append("<ejercicio>");
			xml.append(ejerDEC);
			xml.append("</ejercicio>");
			xml.append("<fechaHora>");
			xml.append(fechaActualStr);
			xml.append("</fechaHora>");
			//-----------------------------------  MODELO 2 --------------------------------------
			//Mediadores F, J, RF y RJ
			xml.append("<corrM1>");

			//-----------------------------------  TABLA a01 --------------------------------------
			xml.append("<ta01t>");
			//"CORREDORES DE SEGUROS PERSONAS FSICAS"
			xml.append(res.get("listados.otroResumen.ta01t"));
			xml.append("</ta01t>");

			xml.append("<ta01l_f01c01>");
			xml.append("");
			xml.append("</ta01l_f01c01>");

			xml.append("<ta01l_f01c0204>");
			xml.append(res.get("listados.otroResumen.ta01l_f01c0204"));
			xml.append("</ta01l_f01c0204>");

			xml.append("<ta01l_f01c0507>");
			xml.append(res.get("listados.otroResumen.ta01l_f01c0507"));
			xml.append("</ta01l_f01c0507>");

			xml.append("<ta01l_f02c01>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c01"));
			xml.append("</ta01l_f02c01>");

			xml.append("<ta01l_f02c02>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c02"));
			xml.append("</ta01l_f02c02>");

			xml.append("<ta01l_f02c03>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c03"));
			xml.append("</ta01l_f02c03>");

			xml.append("<ta01l_f02c04>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c04"));
			xml.append("</ta01l_f02c04>");

			xml.append("<ta01l_f02c05>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c05"));
			xml.append("</ta01l_f02c05>");

			xml.append("<ta01l_f02c06>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c06"));
			xml.append("</ta01l_f02c06>");

			xml.append("<ta01l_f02c07>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c07"));
			xml.append("</ta01l_f02c07>");

			xml.append("<ta01l_f02c08>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c08"));
			xml.append("</ta01l_f02c08>");

			xml.append("<ta01l_f02c09>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c09"));
			xml.append("</ta01l_f02c09>");

			xml.append("<ta01l_f02c10>");
			xml.append(res.get("listados.otroResumen.ta01l_f02c10"));
			xml.append("</ta01l_f02c10>");

			xml.append("<ta01l_f03c01>");
			xml.append(res.get("listados.otroResumen.ta01l_f03c01"));
			xml.append("</ta01l_f03c01>");

			xml.append("<ta01l_f04c01>");
			xml.append(res.get("listados.otroResumen.ta01l_f04c01"));
			xml.append("</ta01l_f04c01>");

			xml.append("<ta01l_f05c01>");
			xml.append(res.get("listados.otroResumen.ta01l_f05c01"));
			xml.append("</ta01l_f05c01>");

			xml.append("<ta01v_f03c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F1()).replaceAll("\\.",",")));
			xml.append("</ta01v_f03c02>");
			
			xml.append("<ta01v_f03c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F2()).replaceAll("\\.",",")));
			xml.append("</ta01v_f03c03>");
			
			xml.append("<ta01v_f03c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F3()).replaceAll("\\.",",")));
			xml.append("</ta01v_f03c04>");
			
			xml.append("<ta01v_f03c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F4()).replaceAll("\\.",",")));
			xml.append("</ta01v_f03c05>");
			
			xml.append("<ta01v_f03c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F5()).replaceAll("\\.",",")));
			xml.append("</ta01v_f03c06>");
			
			xml.append("<ta01v_f03c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F6()).replaceAll("\\.",",")));
			xml.append("</ta01v_f03c07>");
			
			xml.append("<ta01v_f04c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_F1()).replaceAll("\\.",",")));
			xml.append("</ta01v_f04c02>");
			
			xml.append("<ta01v_f04c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_F2()).replaceAll("\\.",",")));
			xml.append("</ta01v_f04c03>");
			
			xml.append("<ta01v_f04c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_F3()).replaceAll("\\.",",")));
			xml.append("</ta01v_f04c04>");
			
			xml.append("<ta01v_f04c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_F4()).replaceAll("\\.",",")));
			xml.append("</ta01v_f04c05>");
			
			xml.append("<ta01v_f04c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_F5()).replaceAll("\\.",",")));
			xml.append("</ta01v_f04c06>");
			
			xml.append("<ta01v_f04c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_F6()).replaceAll("\\.",",")));
			xml.append("</ta01v_f04c07>");
			

			
			
			

			xml.append("<ta01v_f05c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F1()+objInformeOtroDEC.getD39_F1()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c02>");
			
			xml.append("<ta01v_f05c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F2()+objInformeOtroDEC.getD39_F2()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c03>");
			
			xml.append("<ta01v_f05c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F3()+objInformeOtroDEC.getD39_F3()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c04>");
			
			xml.append("<ta01v_f05c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F4()+objInformeOtroDEC.getD39_F4()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c05>");
			
			xml.append("<ta01v_f05c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F5()+objInformeOtroDEC.getD39_F5()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c06>");
			
			xml.append("<ta01v_f05c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_F6()+objInformeOtroDEC.getD39_F6()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c07>");
			
			

			
			
			
			xml.append("<ta01v_f05c08>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD49_F1()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c08>");
			
			xml.append("<ta01v_f05c09>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD49_F2()).replaceAll("\\.",",")));
			xml.append("</ta01v_f05c09>");

			ArrayList<String> al_MediadorCodigo = new ArrayList<String>(); 
			ArrayList<Double> al_MediadorComision = new ArrayList<Double>();

			al_MediadorCodigo = objInformeOtroDEC.getAl_MediadorCodigo();
			al_MediadorComision = objInformeOtroDEC.getAl_MediadorComision();
			
			xml.append("<ta01v_f05c10>");
			int iNumMediadores = 0;
			while(iNumMediadores<al_MediadorCodigo.size()){
				if (al_MediadorCodigo.get(iNumMediadores).equals("F")){
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(al_MediadorComision.get(iNumMediadores)).replaceAll("\\.",",")));
					break;
				}
				iNumMediadores++;
				
			}
			xml.append("</ta01v_f05c10>");
			//-----------------------------------  TABLA a02 --------------------------------------
			xml.append("<ta02t>");
			xml.append(res.get("listados.otroResumen.ta02t"));
			xml.append("</ta02t>");

			xml.append("<ta02l_f01c01>");
			xml.append("");
			xml.append("</ta02l_f01c01>");

			xml.append("<ta02l_f01c0204>");
			xml.append(res.get("listados.otroResumen.ta02l_f01c01"));
			xml.append("</ta02l_f01c0204>");

			xml.append("<ta02l_f01c0507>");
			xml.append(res.get("listados.otroResumen.ta02l_f01c0507"));
			xml.append("</ta02l_f01c0507>");

			xml.append("<ta02l_f02c01>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c01"));
			xml.append("</ta02l_f02c01>");

			xml.append("<ta02l_f02c02>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c02"));
			xml.append("</ta02l_f02c02>");

			xml.append("<ta02l_f02c03>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c03"));
			xml.append("</ta02l_f02c03>");

			xml.append("<ta02l_f02c04>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c04"));
			xml.append("</ta02l_f02c04>");

			xml.append("<ta02l_f02c05>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c05"));
			xml.append("</ta02l_f02c05>");

			xml.append("<ta02l_f02c06>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c06"));
			xml.append("</ta02l_f02c06>");

			xml.append("<ta02l_f02c07>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c07"));
			xml.append("</ta02l_f02c07>");

			xml.append("<ta02l_f02c08>");
			xml.append(res.get("listados.otroResumen.ta02l_f02c08"));
			xml.append("</ta02l_f02c08>");

			xml.append("<ta02l_f03c01>");
			xml.append(res.get("listados.otroResumen.ta02l_f03c01"));
			xml.append("</ta02l_f03c01>");

			xml.append("<ta02l_f04c01>");
			xml.append(res.get("listados.otroResumen.ta02l_f04c01"));
			xml.append("</ta02l_f04c01>");

			xml.append("<ta02l_f05c01>");
			xml.append(res.get("listados.otroResumen.ta02l_f05c01"));
			xml.append("</ta02l_f05c01>");

			xml.append("<ta02v_f03c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J1()).replaceAll("\\.",",")));
			xml.append("</ta02v_f03c02>");
			
			xml.append("<ta02v_f03c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J2()).replaceAll("\\.",",")));
			xml.append("</ta02v_f03c03>");
			
			xml.append("<ta02v_f03c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J3()).replaceAll("\\.",",")));
			xml.append("</ta02v_f03c04>");
			
			xml.append("<ta02v_f03c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J4()).replaceAll("\\.",",")));
			xml.append("</ta02v_f03c05>");
			
			xml.append("<ta02v_f03c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J5()).replaceAll("\\.",",")));
			xml.append("</ta02v_f03c06>");
			
			xml.append("<ta02v_f03c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J6()).replaceAll("\\.",",")));
			xml.append("</ta02v_f03c07>");
			
			xml.append("<ta02v_f04c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_J1()).replaceAll("\\.",",")));
			xml.append("</ta02v_f04c02>");
			
			xml.append("<ta02v_f04c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_J2()).replaceAll("\\.",",")));
			xml.append("</ta02v_f04c03>");
			
			xml.append("<ta02v_f04c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_J3()).replaceAll("\\.",",")));
			xml.append("</ta02v_f04c04>");
			
			xml.append("<ta02v_f04c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_J4()).replaceAll("\\.",",")));
			xml.append("</ta02v_f04c05>");
			
			xml.append("<ta02v_f04c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_J5()).replaceAll("\\.",",")));
			xml.append("</ta02v_f04c06>");
			
			xml.append("<ta02v_f04c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_J6()).replaceAll("\\.",",")));
			xml.append("</ta02v_f04c07>");
			
			xml.append("<ta02v_f05c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J1()+objInformeOtroDEC.getD39_J1()).replaceAll("\\.",",")));
			xml.append("</ta02v_f05c02>");
			
			xml.append("<ta02v_f05c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J2()+objInformeOtroDEC.getD39_J2()).replaceAll("\\.",",")));
			xml.append("</ta02v_f05c03>");
			
			xml.append("<ta02v_f05c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J3()+objInformeOtroDEC.getD39_J3()).replaceAll("\\.",",")));
			xml.append("</ta02v_f05c04>");
			
			xml.append("<ta02v_f05c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J4()+objInformeOtroDEC.getD39_J4()).replaceAll("\\.",",")));
			xml.append("</ta02v_f05c05>");
			
			xml.append("<ta02v_f05c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J5()+objInformeOtroDEC.getD39_J5()).replaceAll("\\.",",")));
			xml.append("</ta02v_f05c06>");
			
			xml.append("<ta02v_f05c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_J6()+objInformeOtroDEC.getD39_J6()).replaceAll("\\.",",")));
			xml.append("</ta02v_f05c07>");
			
//			xml.append("<ta02v_f05c08>");
//			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_F1()).replaceAll("\\.",",")));
//			xml.append("</ta02v_f05c08>");

			xml.append("<ta02v_f05c08>");
			iNumMediadores = 0;
			while(iNumMediadores<al_MediadorCodigo.size()){
				if (al_MediadorCodigo.get(iNumMediadores).equals("J")){
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(al_MediadorComision.get(iNumMediadores)).replaceAll("\\.",",")));
					break;
				}
				iNumMediadores++;
				
			}
			xml.append("</ta02v_f05c08>");

			xml.append("</corrM1>");
			
			//-----------------------------------  MODELO 2 --------------------------------------
			//Mediadores F, J, RF y RJ
			xml.append("<corrM2>");

			//-----------------------------------  TABLA a03 --------------------------------------
			xml.append("<ta03t>");
			xml.append(res.get("listados.otroResumen.ta03t"));
			xml.append("</ta03t>");

			xml.append("<ta03l_f01c01>");
			xml.append("");
			xml.append("</ta03l_f01c01>");

			xml.append("<ta03l_f01c0204>");
			xml.append(res.get("listados.otroResumen.ta03l_f01c0204"));
			xml.append("</ta03l_f01c0204>");

			xml.append("<ta03l_f01c0507>");
			xml.append(res.get("listados.otroResumen.ta03l_f01c0507"));
			xml.append("</ta03l_f01c0507>");

			xml.append("<ta03l_f02c01>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c01"));
			xml.append("</ta03l_f02c01>");

			xml.append("<ta03l_f02c02>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c02"));
			xml.append("</ta03l_f02c02>");

			xml.append("<ta03l_f02c03>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c03"));
			xml.append("</ta03l_f02c03>");

			xml.append("<ta03l_f02c04>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c04"));
			xml.append("</ta03l_f02c04>");

			xml.append("<ta03l_f02c05>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c05"));
			xml.append("</ta03l_f02c05>");

			xml.append("<ta03l_f02c06>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c06"));
			xml.append("</ta03l_f02c06>");

			xml.append("<ta03l_f02c07>");
			xml.append(res.get("listados.otroResumen.ta03l_f02c07"));
			xml.append("</ta03l_f02c07>");

			xml.append("<ta03l_f03c01>");
			xml.append(res.get("listados.otroResumen.ta03l_f03c01"));
			xml.append("</ta03l_f03c01>");

			xml.append("<ta03l_f04c01>");
			xml.append(res.get("listados.otroResumen.ta03l_f04c01"));
			xml.append("</ta03l_f04c01>");

			xml.append("<ta03l_f05c01>");
			xml.append(res.get("listados.otroResumen.ta03l_f05c01"));
			xml.append("</ta03l_f05c01>");

			xml.append("<ta03v_f03c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF1()).replaceAll("\\.",",")));
			xml.append("</ta03v_f03c02>");
			
			xml.append("<ta03v_f03c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF2()).replaceAll("\\.",",")));
			xml.append("</ta03v_f03c03>");
			
			xml.append("<ta03v_f03c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF3()).replaceAll("\\.",",")));
			xml.append("</ta03v_f03c04>");
			
			xml.append("<ta03v_f03c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF4()).replaceAll("\\.",",")));
			xml.append("</ta03v_f03c05>");
			
			xml.append("<ta03v_f03c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF5()).replaceAll("\\.",",")));
			xml.append("</ta03v_f03c06>");
			
			xml.append("<ta03v_f03c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF6()).replaceAll("\\.",",")));
			xml.append("</ta03v_f03c07>");
			
			xml.append("<ta03v_f04c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AF1()).replaceAll("\\.",",")));
			xml.append("</ta03v_f04c02>");
			
			xml.append("<ta03v_f04c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AF2()).replaceAll("\\.",",")));
			xml.append("</ta03v_f04c03>");
			
			xml.append("<ta03v_f04c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AF3()).replaceAll("\\.",",")));
			xml.append("</ta03v_f04c04>");
			
			xml.append("<ta03v_f04c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AF4()).replaceAll("\\.",",")));
			xml.append("</ta03v_f04c05>");
			
			xml.append("<ta03v_f04c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AF5()).replaceAll("\\.",",")));
			xml.append("</ta03v_f04c06>");
			
			xml.append("<ta03v_f04c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AF6()).replaceAll("\\.",",")));
			xml.append("</ta03v_f04c07>");
			
			xml.append("<ta03v_f05c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF1()+objInformeOtroDEC.getD39_AF1()).replaceAll("\\.",",")));
			xml.append("</ta03v_f05c02>");
			
			xml.append("<ta03v_f05c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF2()+objInformeOtroDEC.getD39_AF2()).replaceAll("\\.",",")));
			xml.append("</ta03v_f05c03>");
			
			xml.append("<ta03v_f05c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF3()+objInformeOtroDEC.getD39_AF3()).replaceAll("\\.",",")));
			xml.append("</ta03v_f05c04>");
			
			xml.append("<ta03v_f05c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF4()+objInformeOtroDEC.getD39_AF4()).replaceAll("\\.",",")));
			xml.append("</ta03v_f05c05>");
			
			xml.append("<ta03v_f05c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF5()+objInformeOtroDEC.getD39_AF5()).replaceAll("\\.",",")));
			xml.append("</ta03v_f05c06>");
			
			xml.append("<ta03v_f05c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AF6()+objInformeOtroDEC.getD39_AF6()).replaceAll("\\.",",")));
			xml.append("</ta03v_f05c07>");
			
			//-----------------------------------  TABLA b03 --------------------------------------
			xml.append("<tb03l_f01c01>");
			xml.append(res.get("listados.otroResumen.tb03l_f01c01"));
			xml.append("</tb03l_f01c01>");

			xml.append("<tb03l_f01c0203>");
			xml.append(res.get("listados.otroResumen.tb03l_f01c0203"));
			xml.append("</tb03l_f01c0203>");

			xml.append("<tb03l_f01c0405>");
			xml.append(res.get("listados.otroResumen.tb03l_f01c0405"));
			xml.append("</tb03l_f01c0405>");

			xml.append("<tb03l_f01c06>");
			xml.append(res.get("listados.otroResumen.tb03l_f01c06"));
			xml.append("</tb03l_f01c06>");

			xml.append("<tb03l_f02c01>");
			xml.append("");
			xml.append("</tb03l_f02c01>");

			xml.append("<tb03l_f02c02>");
			xml.append(res.get("listados.otroResumen.tb03l_f02c02"));
			xml.append("</tb03l_f02c02>");

			xml.append("<tb03l_f02c03>");
			xml.append(res.get("listados.otroResumen.tb03l_f02c03"));
			xml.append("</tb03l_f02c03>");

			xml.append("<tb03l_f02c04>");
			xml.append(res.get("listados.otroResumen.tb03l_f02c04"));
			xml.append("</tb03l_f02c04>");

			xml.append("<tb03l_f02c05>");
			xml.append(res.get("listados.otroResumen.tb03l_f02c05"));
			xml.append("</tb03l_f02c05>");

			xml.append("<tb03v_f03c01>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AF1()).replaceAll("\\.",",")));
			xml.append("</tb03v_f03c01>");

			xml.append("<tb03v_f03c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AF2()).replaceAll("\\.",",")));
			xml.append("</tb03v_f03c02>");
			
			xml.append("<tb03v_f03c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AF3()).replaceAll("\\.",",")));
			xml.append("</tb03v_f03c03>");
			
			xml.append("<tb03v_f03c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AF4()).replaceAll("\\.",",")));
			xml.append("</tb03v_f03c04>");
			
			xml.append("<tb03v_f03c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AF5()).replaceAll("\\.",",")));
			xml.append("</tb03v_f03c05>");

			xml.append("<tb03v_f03c06>");
			iNumMediadores = 0;
			while(iNumMediadores<al_MediadorCodigo.size()){
				if (al_MediadorCodigo.get(iNumMediadores).equals("AF")){
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(al_MediadorComision.get(iNumMediadores)).replaceAll("\\.",",")));
					break;
				}
				iNumMediadores++;
				
			}
			xml.append("</tb03v_f03c06>");

			//-----------------------------------  TABLA a04 --------------------------------------
			xml.append("<ta04t>");
			xml.append(res.get("listados.otroResumen.ta04t"));
			xml.append("</ta04t>");

			xml.append("<ta04l_f01c01>");
			xml.append("");
			xml.append("</ta04l_f01c01>");

			xml.append("<ta04l_f01c0204>");
			xml.append(res.get("listados.otroResumen.ta04l_f01c0204"));
			xml.append("</ta04l_f01c0204>");

			xml.append("<ta04l_f01c0507>");
			xml.append(res.get("listados.otroResumen.ta04l_f01c0507"));
			xml.append("</ta04l_f01c0507>");

			xml.append("<ta04l_f02c01>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c01"));
			xml.append("</ta04l_f02c01>");

			xml.append("<ta04l_f02c02>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c02"));
			xml.append("</ta04l_f02c02>");

			xml.append("<ta04l_f02c03>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c03"));
			xml.append("</ta04l_f02c03>");

			xml.append("<ta04l_f02c04>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c04"));
			xml.append("</ta04l_f02c04>");

			xml.append("<ta04l_f02c05>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c05"));
			xml.append("</ta04l_f02c05>");

			xml.append("<ta04l_f02c06>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c06"));
			xml.append("</ta04l_f02c06>");

			xml.append("<ta04l_f02c07>");
			xml.append(res.get("listados.otroResumen.ta04l_f02c07"));
			xml.append("</ta04l_f02c07>");

			xml.append("<ta04l_f03c01>");
			xml.append(res.get("listados.otroResumen.ta04l_f03c01"));
			xml.append("</ta04l_f03c01>");

			xml.append("<ta04l_f04c01>");
			xml.append(res.get("listados.otroResumen.ta04l_f04c01"));
			xml.append("</ta04l_f04c01>");

			xml.append("<ta04l_f05c01>");
			xml.append(res.get("listados.otroResumen.ta04l_f05c01"));
			xml.append("</ta04l_f05c01>");

			xml.append("<ta04v_f03c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ1()).replaceAll("\\.",",")));
			xml.append("</ta04v_f03c02>");
			
			xml.append("<ta04v_f03c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ2()).replaceAll("\\.",",")));
			xml.append("</ta04v_f03c03>");
			
			xml.append("<ta04v_f03c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ3()).replaceAll("\\.",",")));
			xml.append("</ta04v_f03c04>");
			
			xml.append("<ta04v_f03c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ4()).replaceAll("\\.",",")));
			xml.append("</ta04v_f03c05>");
			
			xml.append("<ta04v_f03c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ5()).replaceAll("\\.",",")));
			xml.append("</ta04v_f03c06>");
			
			xml.append("<ta04v_f03c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ6()).replaceAll("\\.",",")));
			xml.append("</ta04v_f03c07>");
			
			xml.append("<ta04v_f04c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AJ1()).replaceAll("\\.",",")));
			xml.append("</ta04v_f04c02>");
			
			xml.append("<ta04v_f04c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AJ2()).replaceAll("\\.",",")));
			xml.append("</ta04v_f04c03>");
			
			xml.append("<ta04v_f04c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AJ3()).replaceAll("\\.",",")));
			xml.append("</ta04v_f04c04>");
			
			xml.append("<ta04v_f04c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AJ4()).replaceAll("\\.",",")));
			xml.append("</ta04v_f04c05>");
			
			xml.append("<ta04v_f04c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AJ5()).replaceAll("\\.",",")));
			xml.append("</ta04v_f04c06>");
			
			xml.append("<ta04v_f04c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD39_AJ6()).replaceAll("\\.",",")));
			xml.append("</ta04v_f04c07>");
			
			xml.append("<ta04v_f05c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ1()+objInformeOtroDEC.getD39_AJ1()).replaceAll("\\.",",")));
			xml.append("</ta04v_f05c02>");
			
			xml.append("<ta04v_f05c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ2()+objInformeOtroDEC.getD39_AJ2()).replaceAll("\\.",",")));
			xml.append("</ta04v_f05c03>");
			
			xml.append("<ta04v_f05c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ3()+objInformeOtroDEC.getD39_AJ3()).replaceAll("\\.",",")));
			xml.append("</ta04v_f05c04>");
			
			xml.append("<ta04v_f05c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ4()+objInformeOtroDEC.getD39_AJ4()).replaceAll("\\.",",")));
			xml.append("</ta04v_f05c05>");
			
			xml.append("<ta04v_f05c06>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ5()+objInformeOtroDEC.getD39_AJ5()).replaceAll("\\.",",")));
			xml.append("</ta04v_f05c06>");
			
			xml.append("<ta04v_f05c07>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD38_AJ6()+objInformeOtroDEC.getD39_AJ6()).replaceAll("\\.",",")));
			xml.append("</ta04v_f05c07>");
			
			//-----------------------------------  TABLA b04 --------------------------------------
			xml.append("<tb04l_f01c01>");
			xml.append(res.get("listados.otroResumen.tb04l_f01c01"));
			xml.append("</tb04l_f01c01>");

			xml.append("<tb04l_f01c0203>");
			xml.append(res.get("listados.otroResumen.tb04l_f01c0203"));
			xml.append("</tb04l_f01c0203>");

			xml.append("<tb04l_f01c0405>");
			xml.append(res.get("listados.otroResumen.tb04l_f01c0405"));
			xml.append("</tb04l_f01c0405>");

			xml.append("<tb04l_f01c06>");
			xml.append(res.get("listados.otroResumen.tb04l_f01c06"));
			xml.append("</tb04l_f01c06>");

			xml.append("<tb04l_f02c01>");
			xml.append("");
			xml.append("</tb04l_f02c01>");

			xml.append("<tb04l_f02c02>");
			xml.append(res.get("listados.otroResumen.tb04l_f02c02"));
			xml.append("</tb04l_f02c02>");

			xml.append("<tb04l_f02c03>");
			xml.append(res.get("listados.otroResumen.tb04l_f02c03"));
			xml.append("</tb04l_f02c03>");

			xml.append("<tb04l_f02c04>");
			xml.append(res.get("listados.otroResumen.tb04l_f02c04"));
			xml.append("</tb04l_f02c04>");

			xml.append("<tb04l_f02c05>");
			xml.append(res.get("listados.otroResumen.tb04l_f02c05"));
			xml.append("</tb04l_f02c05>");

			xml.append("<tb04v_f03c01>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AJ1()).replaceAll("\\.",",")));
			xml.append("</tb04v_f03c01>");

			xml.append("<tb04v_f03c02>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AJ2()).replaceAll("\\.",",")));
			xml.append("</tb04v_f03c02>");
			
			xml.append("<tb04v_f03c03>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AJ3()).replaceAll("\\.",",")));
			xml.append("</tb04v_f03c03>");
			
			xml.append("<tb04v_f03c04>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AJ4()).replaceAll("\\.",",")));
			xml.append("</tb04v_f03c04>");
			
			xml.append("<tb04v_f03c05>");
			xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeOtroDEC.getD53_AJ5()).replaceAll("\\.",",")));
			xml.append("</tb04v_f03c05>");

			xml.append("<tb04v_f03c06>");
			iNumMediadores = 0;
			while(iNumMediadores<al_MediadorCodigo.size()){
				if (al_MediadorCodigo.get(iNumMediadores).equals("AJ")){
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(al_MediadorComision.get(iNumMediadores)).replaceAll("\\.",",")));
					break;
				}
				iNumMediadores++;
				
			}

			xml.append("</tb04v_f03c06>");
			xml.append("</corrM2>");

			
			//-----------------------------------  MODELO 3 --------------------------------------
			//Mediadores F, J, RF y RJ

			//-----------------------------------  TABLA a03 --------------------------------------
//			xml.append("<corrM3>");
//			xml.append("<ta05t>");
//			xml.append(res.get("listados.otroResumen.ta05t"));
//			xml.append("</ta05t>");
//
//			xml.append("<ta05l_f01c0102>");
//			xml.append(res.get("listados.otroResumen.ta05l_f01c0102"));
//			xml.append("</ta05l_f01c0102>");
//
//			xml.append("<ta05l_f02c01>");
//			xml.append(res.get("listados.otroResumen.ta05l_f02c01"));
//			xml.append("</ta05l_f02c01>");
//
//			xml.append("<ta05l_f02c02>");
//			xml.append(res.get("listados.otroResumen.ta05l_f02c02"));
//			xml.append("</ta05l_f02c02>");
//			
//			iNumMediadores = 0;
//			while(iNumMediadores<al_MediadorCodigo.size()){
//				xml.append("<ta05d>");
//				xml.append("<ta05v_f03c01>");
//				xml.append(al_MediadorCodigo.get(iNumMediadores));
//				xml.append("</ta05v_f03c01>");
//
//				xml.append("<ta05v_f03c02>");
//				xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(al_MediadorComision.get(iNumMediadores)).replaceAll("\\.",",")));
//				xml.append("</ta05v_f03c02>");
//				xml.append("</ta05d>");
//				iNumMediadores++;
//				
//			}
//
//
//			xml.append("</corrM3>");
			
			
		xml.append("</informeDEC>");
		
						
		String xmlString = xml.toString();
		
		//En la razon social de algunos mediadores est el smbolo &. Da el error:
		//"The entity name must immediately follow the '&' in the entity reference."
		//Sustituyendo el smbolo & por su codificacin, desaparece el error.
		//Para este informe, NO se va a dar este caso, pero lo dejo.
		xmlString = xmlString.replaceAll("&","&amp;");
		P06BLog.send(2,"P06BInformeOtroResumenDECXML", "getXml(...): Fin");
		return xmlString;
	}
	
}